object FSynt: TSyntAnalyzer
  Formats = <
    item
      DisplayName = 'Default'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clWindowText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
      FormatType = ftCustomFont
    end
    item
      DisplayName = 'Marked block'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clHighlightText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
      BgColor = clHighlight
      FormatType = ftColor
    end
    item
      DisplayName = 'Symbol'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clMaroon
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
    end
    item
      DisplayName = 'Number'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clNavy
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
    end
    item
      DisplayName = 'String'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clBlue
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
    end
    item
      DisplayName = 'Identifier'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clWindowText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
    end
    item
      DisplayName = 'Reserved word'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clWindowText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
    end
    item
      DisplayName = 'Comment'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clRed
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
    end
    item
      DisplayName = 'Preprocessor'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clGreen
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsItalic]
    end>
  TokenRules = <
    item
      DisplayName = 'Comment 1'
      StyleName = 'Comment'
      TokenType = 1
      Expression = '(?s)/\*.*?(\*/|\Z)'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Comment 2'
      StyleName = 'Comment'
      TokenType = 1
      Expression = '//.*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'String'
      StyleName = 'String'
      TokenType = 4
      Expression = '(["'#39'])(\\.|[^\\])*?(\1|$)'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Any name'
      StyleName = 'Identifier'
      TokenType = 2
      Expression = '[a-z_]\w*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'HEX'
      StyleName = 'Number'
      TokenType = 7
      Expression = '0x[\da-f]*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Float'
      StyleName = 'Number'
      TokenType = 6
      Expression = '\d+ \.? \d+ e [\+\-]? \d+ |'#13#10'\d+ \. \d+'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Integer'
      StyleName = 'Number'
      TokenType = 5
      Expression = '\d+'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Single symbol'
      StyleName = 'Symbol'
      TokenType = 3
      Expression = '[\{\}\(\)\[\],;\.]'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Symbol'
      StyleName = 'Symbol'
      TokenType = 3
      Expression = '[/\+\-\*:=<>&/\|\^~!\(\)\[\]\(\)]+'
      ColumnFrom = 0
      ColumnTo = 0
    end>
  BlockRules = <
    item
      DisplayName = 'Key words'
      StyleName = 'Reserved word'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            'break'
            'case'
            'catch'
            'class'
            'const'
            'continue'
            'debugger'
            'default'
            'delete'
            'do'
            'else'
            'enum'
            'export'
            'extends'
            'false'
            'finally'
            'for'
            'function'
            'if'
            'import'
            'in'
            'new'
            'null'
            'return'
            'super'
            'switch'
            'this'
            'throw'
            'true'
            'try'
            'typeof'
            'var'
            'void'
            'while'
            'with')
          TokenTypes = 4
        end>
      HighlightPos = cpBound
      IgnoreAsParent = False
    end
    item
      DisplayName = 'End'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            '}')
          TokenTypes = 8
        end>
      HighlightPos = cpBound
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Begin'
      ConditionList = <
        item
          TagList.Strings = (
            '{')
          TokenTypes = 8
        end>
      IdentIndex = 1
      BlockEnd = 'End'
      DisplayInTree = False
      HighlightPos = cpBound
      IgnoreAsParent = False
    end
    item
      DisplayName = 'class function'
      ConditionList = <
        item
          TagList.Strings = (
            'function')
          TokenTypes = 4
          IgnoreCase = True
        end
        item
          TagList.Strings = (
            '=')
          TokenTypes = 8
        end
        item
          TokenTypes = 4
        end
        item
          TagList.Strings = (
            '.')
          TokenTypes = 8
        end
        item
          TagList.Strings = (
            'prototype')
          TokenTypes = 4
          IgnoreCase = True
        end
        item
          TagList.Strings = (
            '.')
          TokenTypes = 8
        end
        item
          TokenTypes = 4
        end>
      BlockEnd = 'function end'
      NameFmt = '%s-4%sz-7'
      GroupFmt = '%s0()'
      RefToCondEnd = True
      HighlightPos = cpBound
      CollapseFmt = '%s-6  %s0.%s-4%sz-7'
      IgnoreAsParent = False
    end
    item
      DisplayName = 'function start'
      ConditionList = <
        item
          TagList.Strings = (
            'function')
          TokenTypes = 4
        end
        item
          TagList.Strings = (
            '=')
          CondType = tcNotEqual
          TokenTypes = 8
        end>
      BlockEnd = 'function end'
      NameFmt = '%sz-1'
      HighlightPos = cpBound
      CollapseFmt = '%s0 %sz-1'
      IgnoreAsParent = False
    end
    item
      DisplayName = 'function end'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            '}')
          TokenTypes = 8
        end>
      HighlightPos = cpBound
      IgnoreAsParent = False
    end
    item
      DisplayName = '('
      StyleName = 'Marked block'
      ConditionList = <
        item
          TagList.Strings = (
            '(')
          TokenTypes = 8
        end>
      BlockEnd = ')'
      NotCollapsed = True
      DisplayInTree = False
      DynHighlight = dhBound
      HighlightPos = cpBound
      DynSelectMin = True
      IgnoreAsParent = False
    end
    item
      DisplayName = ')'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            ')')
        end>
      HighlightPos = cpAny
      IgnoreAsParent = False
    end
    item
      DisplayName = '{'
      StyleName = 'Marked block'
      ConditionList = <
        item
          TagList.Strings = (
            '{')
          TokenTypes = 8
        end>
      BlockEnd = '}'
      NotCollapsed = True
      DisplayInTree = False
      DynHighlight = dhBound
      HighlightPos = cpBound
      DynSelectMin = True
      IgnoreAsParent = False
    end
    item
      DisplayName = '}'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            '}')
        end>
      HighlightPos = cpAny
      IgnoreAsParent = False
    end
    item
      DisplayName = '['
      StyleName = 'Marked block'
      ConditionList = <
        item
          TagList.Strings = (
            '[')
          TokenTypes = 8
        end>
      BlockEnd = ']'
      NotCollapsed = True
      DisplayInTree = False
      DynHighlight = dhBound
      HighlightPos = cpBound
      DynSelectMin = True
      IgnoreAsParent = False
    end
    item
      DisplayName = ']'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            ']')
        end>
      HighlightPos = cpAny
      IgnoreAsParent = False
    end>
  CodeTemplates = <>
  SubAnalyzers = <>
  SampleText.Strings = (
    ''
    '// example function'
    'function SetEnabled(A,count)'
    '{'
    '  for(i= 0; i< count;i++)'
    '    A(i).Enabled = !A(i).Enabled;'
    ''
    '}'
    '')
  TokenTypeNames.Strings = (
    'Unknown'
    'Comment'
    'Identifier'
    'Symbol'
    'String'
    'Integer const'
    'Float const'
    'Hex const'
    'Char const'
    'Preprocessor')
  MarkedBlockStyle = 'Marked block'
  DefaultStyleName = 'Default'
  Extentions = 'js'
  LexerName = 'Java script'
  SkipSpaces = False
  RestartFromLineStart = True
  LineComment = '--'
  Left = 144
  Top = 184
end
